#include <stdio.h>
#include <limits.h>

typedef long long tezina_t;

#define MAX_N 300
#define MAX_S_VRED 10000000 

int N; 
tezina_t W;
double eps;

int ind[MAX_N];          
tezina_t w[MAX_N];      
tezina_t v[MAX_N];      
int v_s[MAX_N];     

tezina_t DP[MAX_S_VRED + 1];
int roditelj[MAX_S_VRED + 1]; 

tezina_t krug_gore(double x) {
    tezina_t r=(tezina_t)x;
    if(x>(double)r){
        r++;
    }
    return r;
}

void sreckov_plan() {
    if(scanf("%d %lld %lf",&N,&W,&eps)!=3)return;

    tezina_t vmax=0;
    for(int i=0;i<N;i++){
        if(scanf("%lld %lld",&w[i],&v[i])!=2)return;
        ind[i]=i+1;
        if(v[i]>vmax){
            vmax=v[i];
        }
    }

    if(vmax==0){
        printf("0\n\n");
        return;
    }

    double K_d=(eps*vmax)/N;
    tezina_t K=krug_gore(K_d); 
    if(K==0)K=1;

    int max_sum_v_s=0;
    for(int i=0;i<N;i++){
        v_s[i]=(int)(v[i]/K);
        max_sum_v_s+=v_s[i];
    }
    if(max_sum_v_s>MAX_S_VRED){
        max_sum_v_s=MAX_S_VRED;
    }

    DP[0]=0;
    for(int vs=1;vs<=max_sum_v_s;vs++){
        DP[vs]=LLONG_MAX;
        roditelj[vs]=-1;
    }

    for(int i=0;i<N;i++){
        int vp=v_s[i];
        tezina_t wi=w[i];
        
        for(int vs=max_sum_v_s;vs>=vp;vs--){
            if(DP[vs-vp]!=LLONG_MAX){
                tezina_t nova_w=DP[vs-vp]+wi;
                
                if(nova_w<=W&&nova_w>=0&&nova_w<DP[vs]){
                    DP[vs]=nova_w;
                    roditelj[vs]=i; 
                }
            }
        }
    }

    int naj_v_sum=0;
    for(int vs=max_sum_v_s;vs>=0;vs--){
        if(DP[vs]<=W){
            naj_v_sum=vs;
            break;
        }
    }

    int resenja[MAX_N];
    int k=0;
    int tek_v_sum=naj_v_sum;

    while(tek_v_sum>0){
        int i_ponco=roditelj[tek_v_sum];
        if(i_ponco==-1)break;

        resenja[k++]=ind[i_ponco]; 
        tek_v_sum-=v_s[i_ponco];
    }

    printf("%d\n",k);
    for(int i=0;i<k;i++){
        printf("%d%c",resenja[i],(i==k-1)?'\n':' ');
    }
    if(k==0)printf("\n");
}

int main(){
    sreckov_plan();
    return 0;
}